﻿//创建和初始化地图函数：
//标注点数组

function initMap(objdivid, pointX, pointY, MapLevel, Labeltitle, Labelcontent) {
	createMap(objdivid, pointY, pointX, MapLevel);//创建地图
	setMapEvent();//设置地图事件
	addMapControl();//向地图添加控件
	addMarker(pointX, pointY, Labeltitle, Labelcontent);//向地图中添加marker
}

//创建地图函数：
//objdivid:页面div id
//pointX X坐标位置
//pointY Y坐标位置
//MapLevel 百度地图级别
function createMap(objdivid, pointX, pointY, MapLevel) {
	var map = new BMap.Map(objdivid);//在百度地图容器中创建一个地图
	var point = new BMap.Point(pointX, pointY);//定义一个中心点坐标
	map.centerAndZoom(point, MapLevel);//设定地图的中心点和坐标并将地图显示在地图容器中
	window.map = map;//将map变量存储在全局
}

//地图事件设置函数：
function setMapEvent() {
	map.enableDragging();//启用地图拖拽事件，默认启用(可不写)
	map.disableScrollWheelZoom();//禁用地图滚轮放大缩小，默认禁用(可不写)
	map.enableDoubleClickZoom();//禁用鼠标双击放大
	map.enableKeyboard();//禁用键盘上下左右键移动地图，默认禁用(可不写)
}

//地图控件添加函数：
function addMapControl() {
	//向地图中添加缩放控件
	var ctrl_nav = new BMap.NavigationControl({ anchor: BMAP_ANCHOR_TOP_LEFT, type: BMAP_NAVIGATION_CONTROL_ZOOM });
	map.addControl(ctrl_nav);
	//向地图中添加缩略图控件
	var ctrl_ove = new BMap.OverviewMapControl({ anchor: BMAP_ANCHOR_BOTTOM_RIGHT, isOpen: 0 });
	map.addControl(ctrl_ove);
	//向地图中添加比例尺控件
	var ctrl_sca = new BMap.ScaleControl({ anchor: BMAP_ANCHOR_BOTTOM_LEFT });
	map.addControl(ctrl_sca);
}


//创建marker
function addMarker(pointX, pointY, Labeltitle, Labelcontent) {
	var markerArr = [{ title: Labeltitle, content: Labelcontent, point: pointY + "|" + pointX, isOpen: 0, icon: { w: 21, h: 21, l: 0, t: 0, x: 6, lb: 5 } }];
	for (var i = 0; i < markerArr.length; i++) {
		var json = markerArr[i];
		var p0 = json.point.split("|")[0];
		var p1 = json.point.split("|")[1];
		var point = new BMap.Point(p0, p1);
		var iconImg = createIcon(json.icon);
		var marker = new BMap.Marker(point, { icon: iconImg });
		var iw = createInfoWindow(i, pointX, pointY, Labeltitle, Labelcontent);
		var label = new BMap.Label(json.title, { "offset": new BMap.Size(json.icon.lb - json.icon.x + 10, -20) });
		marker.setLabel(label);
		map.addOverlay(marker);
		label.setStyle({
			borderColor: "#808080",
			color: "#333",
			cursor: "pointer",
			border: "0",
			padding: "0"

		});

		(function () {
			var index = i;
			var _iw = createInfoWindow(i, pointX, pointY, Labeltitle, Labelcontent);
			var _marker = marker;
			_marker.addEventListener("click", function () {
				this.openInfoWindow(_iw);
			});
			_iw.addEventListener("open", function () {
				_marker.getLabel().hide();
			})
			_iw.addEventListener("close", function () {
				_marker.getLabel().show();
			})
			label.addEventListener("click", function () {
				_marker.openInfoWindow(_iw);
			})
			if (!!json.isOpen) {
				label.hide();
				_marker.openInfoWindow(_iw);
			}
		})()
	}
}
//创建InfoWindow
function createInfoWindow(i, pointX, pointY, Labeltitle, Labelcontent) {
	var markerArr = [{ title: Labeltitle, content: Labelcontent, point: pointY + "|" + pointX, isOpen: 0, icon: { w: 21, h: 21, l: 0, t: 0, x: 6, lb: 5 } }];
	var json = markerArr[i];
	var iw = new BMap.InfoWindow("<b class='iw_poi_title' title='" + json.title + "'>" + json.title + "</b><div class='iw_poi_content'>" + json.content + "</div>");
	return iw;
}
//创建一个Icon
function createIcon(json) {
	var icon = new BMap.Icon("../img/mark3.png", new BMap.Size(json.w, json.h), { imageOffset: new BMap.Size(-json.l, -json.t), infoWindowOffset: new BMap.Size(json.lb + 5, 1), offset: new BMap.Size(json.x, json.h) })
	return icon;
}



